#ifndef __C_PBCASTINFO_H
#define __C_PBCASTINFO_H

#define WIN32_LEAN_AND_MEAN

#include "Endpoint/cEndpoint.h"
#include <winsock2.h>

class cPbcastNode;
class cMsgBuffer;

typedef struct MsgInfo
{
	DWORD		 timeInserted;
	u_long		 seqNum;
	cPbcastNode* node;	// If NULL then this is not valid
	cMsgBuffer*  msg;
	unsigned int retransReqRemaining;
} MsgInfo;


#define PBCAST_MSG_TYPE_THRU			0
#define PBCAST_MSG_TYPE_FULL_GOSSIP		1
#define PBCAST_MSG_TYPE_MIN_GOSSIP		2
#define PBCAST_MSG_TYPE_DATA			3
#define PBCAST_MSG_TYPE_DATA_DIRECT		4
#define PBCAST_MSG_TYPE_RETR_REQ		5
#define PBCAST_MSG_TYPE_RETR			6
#define PBCAST_MSG_TYPE_RETR_FAIL		7
#define PBCAST_MSG_TYPE_FULL_GOSSIP_REQ 8

// Data header
typedef struct DataHeader
{
	unsigned char ttl;
	char originator[MAX_ENDPOINT_SIZE];	// The endpoint that originated this message.
	u_long  dataSeqNum;
	u_short	subnetTreeRoot;
} DataHeader;

// gossip header
typedef struct GossipHeader
{
	u_long gossipSeqNum;
	u_long numViewNodes;
} GossipHeader;

// Retransmit Header
typedef struct RetransHeader
{
	u_long senderGossipSeqNum;
	u_long numRequests;
} RetransHeader;

// Union of all of the infos for the various message types.
union Info
{
	GossipHeader  gossip;
	DataHeader	  data;
	RetransHeader retrans;
};

// pbcast header
typedef struct Header
{
	Info			info;							// The header particular to the msg type
	unsigned char	msgType;						// The type of message
} Header;

#endif
